/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.IVWLinkerTable;
import filenet.vw.apps.linker.VWLinkerDocTableModel;
import filenet.vw.apps.linker.VWLinkerTablePanel;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class VWDocumentClassLinkPanel
extends JPanel
implements ActionListener {
    private JComboBox m_docClassComboBox = null;
    private VWLinkerTablePanel m_linkTablePanel = null;
    private Frame m_parentFrame = null;
    private IVWIDMLibrary m_library = null;
    private IVWIDMDocClass m_docClass = null;
    private IVWIDMLink[] m_workflowLinks = null;
    private IVWLinkerTable m_linkTableModel = null;

    public VWDocumentClassLinkPanel(Frame parentFrame, IVWIDMLibrary library) {
        this.m_parentFrame = parentFrame;
        this.m_library = library;
        this.layoutControls();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object object = event.getSource();
            if (object == this.m_docClassComboBox) {
                this.performDocClassSelectionAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void layoutControls() {
        try {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createTopPanel(), "First");
            this.add((Component)this.createMiddlePanel(), "Center");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
    }

    private JPanel createTopPanel() {
        JPanel subPanel = null;
        GridBagConstraints gbConst = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(0, 10, 0, 0);
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 0;
            subPanel.add((Component)this.createTitlePanel(), gbConst);
            ++gbConst.gridy;
            gbConst.insets = new Insets(10, 10, 10, 0);
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = -1;
            subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.SelectDocumentClass)), gbConst);
            ++gbConst.gridx;
            gbConst.gridwidth = 0;
            this.m_docClassComboBox = new JComboBox<IVWIDMDocClass>(this.m_library.docClasses());
            this.m_docClassComboBox.setSelectedIndex(0);
            subPanel.add((Component)this.m_docClassComboBox, gbConst);
            this.m_docClass = (IVWIDMDocClass)this.m_docClassComboBox.getSelectedItem();
            this.m_docClassComboBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private JPanel createTitlePanel() {
        JPanel subPanel = null;
        Font aFont = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new BorderLayout(0, 0));
            JLabel titleLabel = new JLabel(VWResource.DocClassWorkFlowLinks, 0);
            aFont = this.getFont();
            if (aFont != null) {
                titleLabel.setFont(new Font(aFont.getName(), 1, aFont.getSize() + 2));
            }
            subPanel.add((Component)titleLabel, "Center");
            subPanel.add(Box.createVerticalStrut(50), "After");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private JPanel createMiddlePanel() {
        JPanel subPanel = null;
        try {
            subPanel = new JPanel();
            Dimension dim = VWStringUtils.stringToDimension(VWResource.LinkerPanelPrefDim);
            if (dim == null) {
                dim = new Dimension(400, 400);
            }
            subPanel.setPreferredSize(dim);
            subPanel.setLayout(new BorderLayout());
            subPanel.setBorder(new VWTitledBorder(VWResource.WorkflowLinkedToDocClass));
            this.m_linkTableModel = new VWLinkerDocTableModel();
            if (this.m_linkTableModel != null) {
                this.m_linkTableModel.setLibrary(this.m_library);
            }
            if (this.m_docClass != null) {
                this.m_workflowLinks = this.m_docClass.getWorkflowLinks(-1, -1);
                if (this.m_workflowLinks != null) {
                    for (int i = 0; i < this.m_workflowLinks.length; ++i) {
                        this.m_linkTableModel.addLink(this.m_workflowLinks[i]);
                    }
                }
            }
            this.m_linkTablePanel = new VWLinkerTablePanel();
            this.m_linkTablePanel.init(this.m_parentFrame, this.m_docClass, this.m_linkTableModel, 1);
            subPanel.add((Component)this.m_linkTablePanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private void performDocClassSelectionAction() {
        int nRowCount = 0;
        try {
            int i;
            this.m_docClass = (IVWIDMDocClass)this.m_docClassComboBox.getSelectedItem();
            if (this.m_docClass == null) {
                return;
            }
            this.m_linkTablePanel.setDocClass(this.m_docClass);
            this.m_linkTablePanel.disableLinkButtons();
            nRowCount = this.m_linkTableModel.getRowCount();
            for (i = nRowCount - 1; i >= 0; --i) {
                this.m_linkTableModel.removeRow(i);
            }
            this.m_workflowLinks = this.m_docClass.getWorkflowLinks(-1, -1);
            if (this.m_workflowLinks != null) {
                for (i = 0; i < this.m_workflowLinks.length; ++i) {
                    this.m_linkTableModel.addLink(this.m_workflowLinks[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

